IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Browse_CD_ES_Log') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Browse_CD_ES_Log 
END
GO

CREATE PROCEDURE [dbo].[CP_Browse_CD_ES_Log]	@pFecha_Desde		DATETIME,
												@pFecha_Hasta		DATETIME,
												@pId_Cliente		INT = NULL,
												@pTipo				CHAR(2) = NULL,/*E: Entrada. S: Salida. ES: Entrada/Salida*/
												@pResultado			CHAR(1) = NULL,/*S: Satisfactorio. E: Erroneo*/
												@pTipo_Filtro		CHAR(1) = NULL,/*A: Por Acceso. C: Por Controlador*/
												@pId_Accesos		VARCHAR(100) = NULL,/*Separados por coma (depende de @pTipo_Filtro)*/
												@pId_Controladores	VARCHAR(100) = NULL/*Separados por coma (depende de @pTipo_Filtro)*/
AS
BEGIN

/*=============================================================================================================================================================*/

/*Variables Locales*/
DECLARE @posicion						INT
DECLARE @longitud						INT
DECLARE @Id_Controlador_Filtro			SMALLINT
DECLARE @Id_Acceso_Filtro				SMALLINT
DECLARE @SqlStr							NVARCHAR(MAX)
/*FIN Variables Locales*/

/*=============================================================================================================================================================*/

SET @pFecha_Desde		= ISNULL(@pFecha_Desde, '19000101')
SET @pFecha_Hasta		= ISNULL(@pFecha_Hasta, '20501231')
SET @pId_Cliente		= ISNULL(@pId_Cliente, 0)

SET @pTipo				= ISNULL(@pTipo, 'ES')
IF(@pTipo = '')
BEGIN
	SET @pTipo = 'ES'
END

SET @pResultado			= ISNULL(@pResultado, '')

SET @pId_Accesos		= ISNULL(@pId_Accesos, '')
IF(RIGHT(@pId_Accesos, 1) = ',')
BEGIN
	SET @pId_Accesos = SUBSTRING(@pId_Accesos, 1, LEN(@pId_Accesos) - 1)
END

SET @pId_Controladores	= ISNULL(@pId_Controladores, '')
IF(RIGHT(@pId_Controladores, 1) = ',')
BEGIN
	SET @pId_Controladores = SUBSTRING(@pId_Controladores, 1, LEN(@pId_Controladores) - 1)
END

/*=============================================================================================================================================================*/


CREATE TABLE #BrowseCDES	(Codigo			INT,
							Tipo			VARCHAR(8),
							Origen			VARCHAR(11),
							Credencial		VARCHAR(100),
							Pers_Cod		INT,
							Pers_Nro_Socio	VARCHAR(14),
							Pers_Nombre		VARCHAR(100), 
							Pers_Categ		VARCHAR(50),
							Fecha			DATE,
							Hora			VARCHAR(8),
							Resultado		VARCHAR(6),
							Observacion		VARCHAR(200),
							Id_Acceso		SMALLINT,
							Acceso			VARCHAR(20),
							Id_Controlador	SMALLINT,
							Controlador		VARCHAR(100))

/*=============================================================================================================================================================*/

SET @SqlStr =	''

SET @SqlStr +=	'INSERT INTO #BrowseCDES '
SET @SqlStr +=	' SELECT'
SET @SqlStr +=	' CE.Id_ES AS Codigo,'
SET @SqlStr +=	' CASE CE.Tipo '
SET @SqlStr +=	' 	WHEN ''E'' THEN ''Entrada'''
SET @SqlStr +=	' 	WHEN ''S'' THEN ''Salida'''
SET @SqlStr +=	' END'
SET @SqlStr +=	' AS Tipo,'
SET @SqlStr +=	' CASE CE.Origen'
SET @SqlStr +=	' 	WHEN ''A'' THEN ''Automatico'''
SET @SqlStr +=	' 	WHEN ''M'' THEN ''Manual'''
SET @SqlStr +=	' END'
SET @SqlStr +=	' AS Origen,'
SET @SqlStr +=	' CE.Id_Tarjeta	AS Credencial,'
SET @SqlStr +=	' CL.Id_Cliente	AS Pers_Cod,'
SET @SqlStr +=	' ISNULL(CL.Id_Cliente_Externo,  '''')	AS Pers_Nro_Socio,'
SET @SqlStr +=	' CL.Razon_Social AS Pers_Nombre,'
SET @SqlStr +=	' CT.Descripcion AS Pers_Categ,'
SET @SqlStr +=	' CONVERT(DATE, CE.Fecha) AS Fecha,'
SET @SqlStr +=	' CONVERT(VARCHAR(8), CE.Fecha, 8) AS Hora,'
SET @SqlStr +=	' CASE CE.Resultado'
SET @SqlStr +=	' 	WHEN ''S'' THEN ''Satisf'''
SET @SqlStr +=	' 	WHEN ''E'' THEN ''Error'''
SET @SqlStr +=	' END'
SET @SqlStr +=	' AS Resultado,'
SET @SqlStr +=	' CONVERT(VARCHAR(100), CE.Observacion)	AS Observacion,'
SET @SqlStr +=	' CA.Id_Acceso AS Id_Acceso,'
SET @SqlStr +=	' CA.Descripcion AS Acceso,'
SET @SqlStr +=	' CC.Id_Controlador	AS Id_Controlador,'
SET @SqlStr +=	' CC.Descripcion AS Controlador'
SET @SqlStr +=	' FROM CD_ES CE, Clientes CL, Clientes_Tipos CT, CD_Accesos CA, CD_Controladores CC'
SET @SqlStr +=	' WHERE'
SET @SqlStr +=	' CE.Id_Cliente = CL.Id_Cliente'
SET @SqlStr +=	' AND ISNULL(CL.Id_Tipo_Cli, 0) = CT.Id_Tipo_Cli'
SET @SqlStr +=	' AND CE.Id_Acceso = CA.Id_Acceso'
SET @SqlStr +=	' AND CE.Id_Controlador = CC.Id_Controlador'
SET @SqlStr +=	' AND CE.Fecha >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) +''''
SET @SqlStr +=	' AND CE.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(dd, 1, @pFecha_Hasta), 112) +'''' 

IF(@pId_Cliente > 0)
BEGIN
	SET @SqlStr +=	' AND CE.Id_Cliente = ' + CONVERT(VARCHAR(10), @pId_Cliente)
END		
		
IF(@pTipo <> 'ES')
BEGIN
	SET @SqlStr +=	' AND CE.Tipo = ''' + @pTipo + ''''
END

IF(@pResultado <> '')
BEGIN
	SET @SqlStr +=	' AND CE.Resultado = '''  + @pResultado + ''''
END

IF(@pTipo_Filtro = 'A')
BEGIN
	--Filtro por Acceso
	SET @SqlStr +=	' AND CE.Id_Acceso IN (' + @pId_Accesos + ')'
END

IF(@pTipo_Filtro = 'C')
BEGIN
	--Filtro por Controlador
	SET @SqlStr +=	' AND CE.Id_Controlador IN (' + @pId_Controladores + ')'
END

/*=============================================================================================================================================================*/

EXECUTE sp_executesql @SqlStr

SELECT * FROM #BrowseCDES

DROP TABLE #BrowseCDES

/*=============================================================================================================================================================*/

END


/*
EXEC dbo.CP_Browse_CD_ES_Log	'20220703',	/*@pFecha_Desde*/
								'20220703',	/*@pFecha_Hasta*/
								0,	/*@pId_Cliente*/
								'E',/*@pTipo:						E: Entrada. S: Salida. ES: Entrada/Salida*/
								'S',/*@pResultado:					S: Satisfactorio. E: Erroneo*/
								'C',/*@pTipo_Filtro:				A: Por Acceso. C: Por Controlador*/
								'',/*@pId_Accesos:					Separados por coma (depende de @pTipo_Filtro)*/
								'2,6'/*@pId_Controladores:			Separados por coma (depende de @pTipo_Filtro)*/

EXEC dbo.CP_Browse_CD_ES_Log	'20220813',	/*@pFecha_Desde*/
								'20220813',	/*@pFecha_Hasta*/
								0,	/*@pId_Cliente*/
								'E',/*@pTipo:						E: Entrada. S: Salida. ES: Entrada/Salida*/
								'',/*@pResultado:					S: Satisfactorio. E: Erroneo*/
								'C',/*@pTipo_Filtro:				A: Por Acceso. C: Por Controlador*/
								'',/*@pId_Accesos:					Separados por coma (depende de @pTipo_Filtro)*/
								'89'/*@pId_Controladores:			Separados por coma (depende de @pTipo_Filtro)*/
*/
